<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>رأى العين للبصريات</title>

    <!-- Bootstrap 5 RTL CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">

    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- Animate.css for smooth animations -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">

    <style>
        body {
            background: linear-gradient(135deg, #ffffff 0%, #086683 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            overflow-x: hidden;
        }

        .logo-container {
            animation: float 6s ease-in-out infinite;
        }

        @keyframes float {

            0%,
            100% {
                transform: translateY(0) rotate(0deg);
            }

            50% {
                transform: translateY(-30px) rotate(2deg);
            }
        }

        .logo-glow {
            filter: drop-shadow(0 0 30px rgba(255, 255, 255, 0.5));
        }

        .btn-erp {
            background: linear-gradient(45deg, #005eea, #00c0fa);
            border: none;
            padding: 20px 50px;
            font-size: 1.4rem;
            font-weight: 600;
            border-radius: 50px;
            transition: all 0.4s ease;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            position: relative;
            overflow: hidden;
        }

        .btn-erp:hover {
            transform: translateY(-5px) scale(1.05);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.3);
        }

        .btn-erp::after {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.7s ease;
        }

        .btn-erp:hover::after {
            left: 100%;
        }

        .bg-pattern {
            position: absolute;
            width: 100%;
            height: 100%;
            background-image:
                radial-gradient(circle at 20% 80%, rgba(255, 255, 255, 0.1) 2px, transparent 2px),
                radial-gradient(circle at 80% 20%, rgba(255, 255, 255, 0.1) 2px, transparent 2px);
            background-size: 50px 50px;
            z-index: -1;
        }

        .pulse-circle {
            position: absolute;
            width: 400px;
            height: 400px;
            border-radius: 50%;
            background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
            animation: pulse 4s ease-in-out infinite;
        }

        @keyframes pulse {

            0%,
            100% {
                transform: scale(1);
                opacity: 0.3;
            }

            50% {
                transform: scale(1.2);
                opacity: 0.1;
            }
        }
    </style>
</head>

<body class="d-flex align-items-center justify-content-center text-white">
    <!-- Background Elements -->
    <div class="bg-pattern"></div>
    <div class="pulse-circle" style="top: -200px; right: -200px;"></div>
    <div class="pulse-circle" style="bottom: -200px; left: -200px; animation-delay: 2s;"></div>

    <!-- Main Content -->
    <div class="container text-center px-4">
        <div class="row justify-content-center">
            <div class="col-12 col-md-8 col-lg-6">
                <!-- Animated Logo -->
                <div class="logo-container mb-5">
                    <img src="<?php echo e(asset('ra2ylogo.png')); ?>" alt="رأى العين للبصريات" class="logo-glow img-fluid"
                        style="max-width: 400px;"
                        onerror="this.onerror=null; this.src='https://via.placeholder.com/400x200/005eea/00c0fa?text=رأى+العين+لللبصريات'">
                </div>

                <!-- Welcome Text -->
                <h1 class="display-4 fw-bold mb-4 animate__animated animate__fadeInUp">
                    مرحباً بكم في <span class="text-warning">رأى العين للبصريات</span>
                </h1>

                <p class="lead mb-5 animate__animated animate__fadeInUp animate__delay-1s">
                    نظام الإدارة المتكامل للبصريات والرعاية البصرية
                </p>

                <!-- ERP Login Button -->
                <div class="mt-5 animate__animated animate__fadeInUp animate__delay-2s">
                    <a href="YOUR_ERP_LOGIN_URL_HERE" target="_blank" class="btn btn-erp text-white mb-3">
                        <i class="fas fa-sign-in-alt me-2"></i>
                        الدخول إلى نظام الإدارة
                    </a>

                    <p class="small text-light opacity-75">
                        <i class="fas fa-shield-alt me-1"></i>
                        نظام آمن ومشفّر
                    </p>
                </div>

                <!-- Loading Animation -->
                <div class="mt-5">
                    <div class="spinner-border text-light opacity-50" role="status" style="width: 3rem; height: 3rem;">
                        <span class="visually-hidden">جاري التحميل...</span>
                    </div>
                    <p class="mt-2 small text-light opacity-75">جاهز للاتصال بالنظام</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // Simple animation on load
        document.addEventListener('DOMContentLoaded', function () {
            const logo = document.querySelector('.logo-container');
            const button = document.querySelector('.btn-erp');

            // Add click effect to button
            button.addEventListener('mousedown', function () {
                this.style.transform = 'translateY(-2px) scale(0.98)';
            });

            button.addEventListener('mouseup', function () {
                this.style.transform = 'translateY(-5px) scale(1.05)';
            });

            // Auto-hide spinner after 3 seconds
            setTimeout(() => {
                document.querySelector('.spinner-border').style.display = 'none';
                document.querySelector('.spinner-border').nextElementSibling.textContent = 'جاهز للدخول';
            }, 3000);
        });
    </script>
</body>

</html>
<?php /**PATH D:\KSA Projects\ra2y_el3een\eye\resources\views/welcome.blade.php ENDPATH**/ ?>